/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.ftp.preferences;

import com.aptana.core.util.StringUtil;
import com.aptana.ide.core.io.preferences.PermissionDirection;
import com.aptana.ide.core.io.preferences.PreferenceUtils;
import com.aptana.ide.ui.io.preferences.PermissionsGroup;
import com.aptana.ui.ftp.preferences.Messages;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class UpdatePermissionsComposite
extends Composite {
    private static final String FOR_FILES = Messages.UpdatePermissionsComposite_ForFiles;
    private static final String FOR_FOLDERS = Messages.UpdatePermissionsComposite_ForFolders;
    private static final String[] COMBO_ITEMS = new String[]{FOR_FILES, FOR_FOLDERS};
    private Button updatePermCheckbox;
    private Button preservePermButton;
    private Button specificPermButton;
    private Combo forFileFolderCombo;
    private PermissionsGroup permissionsGroup;
    private Map<String, Long> permissionsMap;

    public UpdatePermissionsComposite(Composite parent, PermissionDirection direction) {
        super(parent, 0);
        this.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        this.permissionsMap = new HashMap<String, Long>();
        this.updatePermCheckbox = new Button((Composite)this, 32);
        this.updatePermCheckbox.setText(Messages.UpdatePermissionsComposite_LBL_UpdatePermissions);
        this.updatePermCheckbox.setSelection(PreferenceUtils.getUpdatePermissions((PermissionDirection)direction));
        this.updatePermCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdatePermissionsComposite.this.updateStates();
            }
        });
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(20, 0, 0, 0).spacing(5, 0).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.preservePermButton = new Button(composite, 16);
        this.preservePermButton.setText(Messages.UpdatePermissionsComposite_LBL_ToSourcePermissions);
        boolean useSpecificPermissions = PreferenceUtils.getSpecificPermissions((PermissionDirection)direction);
        this.preservePermButton.setSelection(!useSpecificPermissions);
        this.preservePermButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdatePermissionsComposite.this.specificPermButton.setSelection(false);
                UpdatePermissionsComposite.this.updateStates();
            }
        });
        Composite specificPermComp = new Composite(composite, 0);
        specificPermComp.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        this.specificPermButton = new Button(specificPermComp, 16);
        this.specificPermButton.setText(StringUtil.makeFormLabel((String)Messages.UpdatePermissionsComposite_LBL_ToSpecificPermissions));
        this.specificPermButton.setSelection(useSpecificPermissions);
        this.specificPermButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdatePermissionsComposite.this.preservePermButton.setSelection(false);
                UpdatePermissionsComposite.this.updateStates();
            }
        });
        this.forFileFolderCombo = new Combo(specificPermComp, 12);
        this.forFileFolderCombo.setItems(COMBO_ITEMS);
        this.forFileFolderCombo.setText(COMBO_ITEMS[0]);
        this.forFileFolderCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdatePermissionsComposite.this.updatePermissionsGroup();
            }
        });
        this.permissionsGroup = new PermissionsGroup(specificPermComp);
        this.permissionsGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).indent(20, 0).create());
        this.permissionsMap.put(FOR_FILES, PreferenceUtils.getFilePermissions((PermissionDirection)direction));
        this.permissionsMap.put(FOR_FOLDERS, PreferenceUtils.getFolderPermissions((PermissionDirection)direction));
        this.updatePermissionsGroup();
        this.permissionsGroup.addListener(new PermissionsGroup.Listener(){

            public void permissionsModified() {
                UpdatePermissionsComposite.this.permissionsMap.put(UpdatePermissionsComposite.this.forFileFolderCombo.getText(), UpdatePermissionsComposite.this.permissionsGroup.getPermissions());
            }
        });
        this.updateStates();
    }

    public boolean getUpdatePermissions() {
        return this.updatePermCheckbox.getSelection();
    }

    public boolean getSpecificPermissions() {
        return this.specificPermButton.getSelection();
    }

    public long getFilePermissions() {
        return this.permissionsMap.get(FOR_FILES);
    }

    public long getFolderPermissions() {
        return this.permissionsMap.get(FOR_FOLDERS);
    }

    public void restoreDefaults() {
        this.updatePermCheckbox.setSelection(true);
        this.preservePermButton.setSelection(false);
        this.specificPermButton.setSelection(true);
        this.forFileFolderCombo.setText(COMBO_ITEMS[0]);
        this.permissionsMap.put(FOR_FILES, 438L);
        this.permissionsMap.put(FOR_FOLDERS, 511L);
        this.updatePermissionsGroup();
        this.updateStates();
    }

    private void updatePermissionsGroup() {
        if (this.isForFilesSelected()) {
            this.permissionsGroup.setPermissions(this.permissionsMap.get(FOR_FILES).longValue());
        } else {
            this.permissionsGroup.setPermissions(this.permissionsMap.get(FOR_FOLDERS).longValue());
        }
    }

    private void updateStates() {
        boolean updatePermissions = this.updatePermCheckbox.getSelection();
        boolean useSpecificPermissions = this.specificPermButton.getSelection();
        this.preservePermButton.setEnabled(updatePermissions);
        this.specificPermButton.setEnabled(updatePermissions);
        this.forFileFolderCombo.setEnabled(updatePermissions && useSpecificPermissions);
        this.permissionsGroup.setEnabled(updatePermissions && useSpecificPermissions);
    }

    private boolean isForFilesSelected() {
        return FOR_FILES.equals(this.forFileFolderCombo.getText());
    }
}

